﻿(function ($) {
    $.fn.progressTimer = function (options) {
        var settings = $.extend({}, $.fn.progressTimer.defaults, options);
        this.each(function () {
            $(this).empty();
            var barContainer = $("<div>").addClass("progress");
            var bar = $("<div>").addClass("progress-bar progress-bar-striped bg-success").attr("role", "progressbar").attr("aria-valuenow", "0").attr("aria-valuemin", "0").attr("aria-valuemax", settings.timeLimit);
            bar.appendTo(barContainer);
            barContainer.appendTo($(this));
            var start = new Date;
            var limit = settings.timeLimit * 1e3;
            var interval = window.setInterval(function () {
                var elapsed = new Date - start;
                bar.width(elapsed / limit * 100 + "%");
                if (limit - elapsed <= 5e3) bar.removeClass("bg-success").removeClass("bg-danger").addClass("bg-warning");
                if (elapsed >= limit) {
                    window.clearInterval(interval);
                    bar.removeClass("bg-success").removeClass("bg-warning").addClass("bg-danger");
                    settings.onFinish.call(this)
                }
            }, 250)
        });
        return this
    };
    $.fn.progressTimer.defaults = {
        timeLimit: 60,
        warningThreshold: 5,
        onFinish: function () {},
        baseStyle: "",
        warningStyle: "bg-warning",
        completeStyle: "bg-danger"
    }
})(jQuery);
